function [data]=STM32F103_GET_PLOT_V3_6_7(skt,nbins,Spawn)
%function [data]=STM32F103_GET_PLOT_V3_6_7(skt,nbins,dummy)
%  Ian Stothers for DeIce inc
% Dec 12th 2022 to Dec 19th 2022
% Adding stuff to support micro dft
% Dec 20th Ian Stothers
% Fix for curtis noticed bug - atten was evaluated outside of the aquisition loop
%  Dec 21st Ian Stothers - added ip to graph title bars
% Feb 15th-22nd 2023 added temperature input to screen - not very accurate
% May 8-10th 2023 - Mod to improve interaction with dftest_RES
% Re-ordering calibration to make more orthogonal
% June 20th 2023 - Ian Stothers
% Fixed issue with tfsc use
% Added Zero Ph button
% Reordered tfsc and tfoc buttons to refecl use order

% order should be
% Open Circuit load
% wait 10-20 secs - until imp average settles
% press Set tfoc
% Short circuit load
% wait 10-20 secs - until imp average settles
% press Set tfsc
% press save tf
% Resistive (50 ohm load)
% wait 10-20 secs - until imp average settles
% press Zero Ph


%
% Adjust ADC_Scale to get current and voltage scaling correct
% read in existing ADC_Scale
% ADC_Scale=udpget(skt,'ADC_Scale');
% With RF voltmeter - scope or OCTIVE attached to the board output and known
% Voltage current method
% 50 ohm? load - independent measure voltage on output as Vout (rms)
% obtain voltage from Screen Voltage measure say Vm or with abs(df(bin,1))
%  Adjust ADC_Scale for voltage correctness
% ADC_Scale(1,1)=ADC_Scale(1,1)*Vout/Vm
% Note ADC_Scale is real
%
% 50 ohm? load - independent measure Current on output as Iout (rms)
% obtain Current from Screen Voltage measure say Im or with abs(df(bin,2))
%  Adjust ADC_Scale for Current correctness
% ADC_Scale(2,2)=ADC_Scale(2,2)*Iout/Im
% Note ADC_Scale is real
% Save New ADC_Scale to the microcontroller
% udpset(skt,'ADC_Scale',ADC_Scale);
% udpprogconfig(skt);
%
% Power impedance method
% for known load R
% ADC_Scale(1,1)=ADC_Scale(1,1)*R/Impedence average
%  or ADC_Scale(1,1)=ADC_Scale(1,1)*R/abs(Imp_Ave)
% For known Power P (assumed real at this stage)
% ADC_Scale=ADC_Scale*sqrt(P/(Power Average));
%  or ADC_Scale=ADC_Scale*sqrt(P/abs(Pow_Ave));
% Save New ADC_Scale to the microcontroller
% udpset(skt,'ADC_Scale',ADC_Scale);
% udpprogconfig(skt);
%
% Added bits to switch off dodft -
%
% todo - buttons for above?
%



  nharm=5;

  if(exist('skt')==0)
    skt=sktopen('192.168.1.4');
  endif
  if (ischar(skt))
   skt=sktopen(skt);
  endif

  if(exist('nbins')==0)   nbins=2048; endif

 if(exist('Spawn')==0)
  %STM32F103_GET_PLOT_V3_6_7(skt,nbins,dummy)
  callstr1= ["STM32F103_GET_PLOT_V3_6_7("...
  sprintf("\'%s\',",skt.ip)...
  sprintf("%d,",nbins)...
  sprintf("%d);",1)...
  ];
  octave_spawn(callstr1);
  return
 endif


  noplot=0;
  %udpreset(skt); %will clear dodft
  old_dodft=udpget(skt,'DoTheDFT');
  udpset(skt,'DoTheDFT',0);
  pkg load signal;
  BuildName=udpget(skt,"BuildName");
  BuildName=BuildName(find(BuildName>0));
  BuildTimeStamp=udpget(skt,"BuildTimeStamp");
  BuildTimeStamp=BuildTimeStamp(find(BuildTimeStamp>0));


%%Calibration Bits%%%
% Calibration initial match for rload only
  Vcal= 1*exp(-7*i*pi/180); % Compensate for phase angle into voltage input vs current with resistive load
  Ical= 1;      % Note the 1 in Vcal and Ical can be used to change non frequency sensitive gain issues - or use ADC_Scale
  ADC_Scale = [248.34 0; 0 24];  % from Arlie
  Radc=1000;   % For calcullation of atten
  Cadc=11e-12; % For calcullation of atten
%% end of calibration bits

Vtemp=0;
  SRATE_MAX=875000;

  if (size(findname(skt.name,"ADC_Scale"))>0)
   ADC_Scale=udpget(skt,'ADC_Scale');
  endif
  if (size(findname(skt.name,"Vcal"))>0)
   Vcal=udpget(skt,'Vcal')*[1 ; i];
  endif
  if (size(findname(skt.name,"Ical"))>0)
   Ical=udpget(skt,'Ical')*[1 ; i];
  endif
  if (size(findname(skt.name,"ADC_RC"))>0)
   ADC_RC=udpget(skt,'ADC_RC');
  else
   ADC_RC=Radc*Cadc;
  endif

  %tfoc=exp(i*pi*113/180)/365;  % open circuit output impedance - measured by setting lod open and tfoc=0;
  if (size(findname(skt.name,"tfoc"))>0)
   tfocs=udpget(skt,'tfoc');
   tfoc=tfocs(1)+i*tfocs(2);
  else
   tfoc=0;
  endif
  if (size(findname(skt.name,"tfsc"))>0)
   tfscs=udpget(skt,'tfsc');
   tfsc=tfscs(1)+i*tfscs(2);
  else
   tfsc=0;
  endif
  PartSerno=udpget(skt,'PartSerno');
  n=nbins;
  win=flattopwin(n);
  win=sqrt(2)*win/(sum(win));
  win=win*ones(1,2);

  SRate=STM32F103_ADC_SETUP(skt,[1;0],6750000/8); % make 1st channel volts 2nd current
  STM32F103_CC_SETUP_B3(skt);
  Tvec=(1:nbins)/SRate;
  udpset(skt,'DoTheDFT',0);
  f=STM32F103_CC_GET(skt);
  oldf=zeros(5,1);
  oldf(2:5)=oldf(1:4);
  oldf(1)=f;
  setenv('XDG_SESSION_TYPE','x11');

  if (size(findname(skt.name,"ADC_SR"))>0)
   udpset(skt,'ADC_SR',SRate);
  endif
  harmhand=zeros(1,nharm);
  getno=0;

  Imp_Filt=0.1;
  Imp_Ave_sxy=0.0;
  Imp_Ave_sxx=0.0;
  Imp_Ave=0.0;
  Pow_Ave=0.0;
  Raw_Imp_Ave_sxy=0.0;
  Raw_Imp_Ave_sxx=0.0;
  Raw_Imp_Ave=0.0;
  Raw_Pow_Ave=0.0;

  while (min(size(kbhit(1)))<1)
   f=STM32F103_CC_GET(skt);
    if (f<1e6)
      f=median(oldf);
    else
      oldf(2:5)=oldf(1:4);
      oldf(1)=f;
    endif
    atten=abs(1/(1+i*f*2*pi*ADC_RC)); % Compensate for rc input in STM32ADC
    bin=floor(0.5+((f/SRate)-floor(f/SRate))*nbins)+1;
    if (bin>nbins) bin=nbins; endif
    dat=STM32F103_ADC_PLOT(skt,nbins,-1)';

    %    dat=dat(:,2:-1:1);
    md=ones(nbins,1)*mean(dat);
    Vref_Scale=1.5/mean(mean(dat));
    data=(dat-md)*Vref_Scale;

% Set up to read temp sensor
    tmpsqr3=udpget(skt,"ADC1_SQR3");
    udpset(skt,"ADC1_SQR3",16);
    pause(0.001);


%read temp sensor
    tdat=udpget(skt,"ADC1_DR");



%Set multiplexor back to preset value

    udpset(skt,"ADC1_SQR3",tmpsqr3);
    tvolts=[floor(tdat/2^16)  bitand(tdat,65535)  ](2)*3.3/65536;
    temper=((1.50-tvolts)/0.0043)+25; %1.50 and 0.0043 are approx from stm32 datasheet

%    data=sin(bin*2*pi*(1:nbins)/nbins)'*ones(1,2);
    df=fft(data.*win);
    dfraw=df;
    dftmp=df(:,2)-tfoc*df(:,1);
    df(:,1)=df(:,1)-tfsc*df(:,2);
    df(:,2)=dftmp;
    df(:,1)=df(:,1)*Vcal;
    df(:,2)=df(:,2)*Ical;
    df=df*ADC_Scale/atten;


%    dfraw=df;
%    df(:,2)=df(:,2)-tfoc*df(:,1);
%    df(:,1)=df(:,1)-tfsc*df(:,2);
    if ((bin>3)&&(bin<(nbins-2)))
    [dbin,didx]=max(abs(df(bin-1:(bin+1))));
    bin=bin+didx-2;
    endif
% Impedance filter
    Imp_Ave_sxy=((1-Imp_Filt)*Imp_Ave_sxy)+(Imp_Filt*(df(bin,1)*conj(df(bin,2))));
    Imp_Ave_sxx=((1-Imp_Filt)*Imp_Ave_sxx)+(Imp_Filt*(df(bin,2)*conj(df(bin,2))));
    Imp_Ave=Imp_Ave_sxy/Imp_Ave_sxx;
    Pow_Ave=Imp_Ave_sxy;

    Raw_Imp_Ave_sxy=((1-Imp_Filt)*Raw_Imp_Ave_sxy)+(Imp_Filt*(dfraw(bin,1)*conj(dfraw(bin,2))));
    Raw_Imp_Ave_sxx=((1-Imp_Filt)*Raw_Imp_Ave_sxx)+(Imp_Filt*(dfraw(bin,2)*conj(dfraw(bin,2))));
    Raw_Imp_Ave=Raw_Imp_Ave_sxy/Raw_Imp_Ave_sxx;
    Raw_Pow_Ave=Raw_Imp_Ave_sxy;


    res=[sprintf("Freqency=%2.4f MHz",f/1e6)
    sprintf("Impedance=%4.3f Ohms  %4.1f Degrees",abs(df(bin,1)/df(bin,2)),(180/pi)*angle(df(bin,1)/df(bin,2)))
    sprintf("Impedance Average=%4.3f Ohms  %4.1f Degrees",abs(Imp_Ave),(180/pi)*angle(Imp_Ave))
    sprintf("Power    Real=%4.3f  Imag=%4.3f  W",real(df(bin,1)*df(bin,2)'),imag(df(bin,1)*df(bin,2)'))
    sprintf("Power Average   Real=%4.3f  Imag=%4.3f  W",real(Pow_Ave),imag(Pow_Ave))
    sprintf("Voltage = %4.3f Vrms",abs(df(bin,1)))
    sprintf("Current = %4.3f Irms",abs(df(bin,2)))
    sprintf("Temp Sens Volts = %4.3f Volts",tvolts)
    sprintf("Temperature  = %4.3f Deg C",temper)
    sprintf("Part No.:%d  Serial  No.:%d  BuildName:%s  BuildTimeStamp:%s",PartSerno(1),PartSerno(2),BuildName,BuildTimeStamp)];

    if (getno<0.5)
     getno=1;

%     f3=figure(3);

%     set(f3,"numbertitle","off");
%     set(f3,'name','STM32F103_GET_PLOT');
     f1=figure(1);
     set(f1,"numbertitle","off");
     set(f1,'name',['STM32F103_GET_PLOT IP - ' skt.ip]);
     clf
     pdata=data*ADC_Scale/atten;
     plot(Tvec,pdata');
     f1tit=title(res);


     grid on;
     figure(1)
     f1c=get(f1,'children');
     axis([0 nbins/SRate -150 150]);
     f1cc=get(f1c,'children');
     legend(['Volts';'Amps ']);

     xlabel(['                           Seconds      ' sprintf('Sample Rate = %6.1f',SRate)]   );
     ylabel('Volts');
     pb1=stopbut(f1,[61  5 55 22],"Set tfsc");
     pb2=stopbut(f1,[1  5 55 22],"Set tfoc");
     pb3=stopbut(f1,[181  5 55 22],"Save tf");
     pb4=stopbut(f1,[121  5 55 22],"Zero Ph");


     f2=figure(2);
     set(f2,"numbertitle","off");
     set(f2,'name',['STM32F103_GET_PLOT - ' skt.ip]);
     clf;
     hold off;
     plot(20*log10(abs(df(2:(nbins),:))))
     axis([1 nbins -50 70]);
     grid on;
     ylabel('dB re 1 volt or 1 amp');
     xlabel('Frequency bin')
     f2c=get(f2,'children');
     f2cc=get(f2c,'children');
     t2=title(sprintf('Frequency = %fMHz',f/1e6));
     hold on
%     f3=plot(bin,60,'*');
     for k=1:nharm
        bint=floor(0.5+(((f*k)/SRate)-floor((f*k)/SRate))*nbins)+1;
        if (bint>nbins)
          bint=nbins;
        endif
        harmhand(k)=text(bint,70-(3*k),sprintf("%df",k));
     end
     legend(['Volts';'Amps ']);



     commandwindow
    else


%     figure(1);
%     plot(Tvec,data);
     pdata=data*ADC_Scale/atten;
     set(f1cc(2),'ydata',pdata(:,1)');
     set(f1cc(1),'ydata',pdata(:,2)');

     set(f1tit,'string',res);
%     title(sprintf('Frequency = %fMHz',f/1e6));


%     figure(2)
      hold off
%     plot(20*log10(abs(df(2:1023,:))))
      set(f2cc(2),'ydata',20*log10(abs(df(2:nbins,1)))');
      set(f2cc(1),'ydata',20*log10(abs(df(2:nbins,2)))');
      set(t2,'string',sprintf('Frequency = %fMHz  Bin - %d',f/1e6,bin));

      hold on
%      set(f3,'xdata',bin-1) ;
 %   plot(bin,10,'*');
      for k=1:nharm
        bint=floor(0.5+(((f*k)/SRate)-floor((f*k)/SRate))*nbins)+1;
        if (bint>nbins)
          bint=nbins;
        endif
        set(harmhand(k),'position',[bint get(harmhand(k),'position')(2) 0]);
      end
     endif

     if(get(pb1,"value")==1)
      tfsc=Raw_Imp_Ave;
      set(pb1,"value",0);
     endif

     if(get(pb2,"value")==1)
      tfoc=1/Raw_Imp_Ave;
      set(pb2,"value",0);
     endif

     if(get(pb3,"value")==1)
      udpset(skt,'tfoc',[real(tfoc) imag(tfoc)]);
      udpset(skt,'tfsc',[real(tfsc) imag(tfsc)]);
      udpset(skt,'Vcal',[real(Vcal) imag(Vcal)]);
      set(pb3,"value",0);
      udpprogconfig(skt);
     endif

    if(get(pb4,"value")==1)
      erang=(180/pi)*angle(Imp_Ave);
      Vcal=Vcal*exp(-i*erang*pi/180);
      set(pb4,"value",0);
     endif


   pause(0.05)
  endwhile
udpset(skt,'DoTheDFT',old_dodft);
endfunction



function [pb]=stopbut(f,pos,txt)
 pb=uicontrol(...
 "style","togglebutton",...
 "string",txt,...
 "position",pos);
endfunction

